<%! 

////////////////////////////////////////////////////////////
// written by Transether
// Version 0.1001
//
// function writeHeader($user,$pwd, $clear)
//
// function validateUser($user,$pwd)
// 
// function writePostField($name,$value) 
// 
// function throwsError($error) 
// 
/////////////////////////////////////////////////////////////


// Note: 	Include "Common.inc" before including this file.


/////////////////////////////////////////////////////////////
// Constants
/////////////////////////////////////////////////////////////

// Number of movies to show per screen
//
final int MAX_MOVIES=3;

// path to wap directory. no last slash
//
final String WAP_URL= "http://216.74.143.52";

// session parameters
//
final String USER_PASSWORD_SESSID = "password";
final String USER_SCREENNAME_SESSID = "screenName";

//////////////////////////////////////////////////////////////
//
//	writeHeader()
//
//		Writes the approriate header to the client, clearing cookies
//		if necessary.
//

public void writeHeader(HttpSession session, HttpServletRequest req, HttpServletResponse response, boolean clear) {

	if (clear == true) { // || user.length() == 0 || password.length() == 0) {
	
		Cookie USERCookie = new Cookie(USERID_PARAM,"");	
		USERCookie.setDomain(WAP_URL);
		USERCookie.setMaxAge(60*60*24*365);
		USERCookie.setPath("/");
		response.addCookie(USERCookie);
		
		Cookie PWDCookie = new Cookie(PASSWORD_PARAM,"");	
		PWDCookie.setDomain(WAP_URL);
		PWDCookie.setMaxAge(60*60*24*365);
		PWDCookie.setPath("/");
		response.addCookie(PWDCookie);
		System.out.println("clear==true!!");
	} else {
	
		String email = (String)session.getAttribute(USER_EMAIL_SESSID);
		String pwd = (String)session.getAttribute(USER_PASSWORD_SESSID);

		if (email == null) {
			email = req.getParameter(USERID_PARAM);
		}
		if (pwd == null) {
			pwd = req.getParameter(PASSWORD_PARAM);
		}

		Cookie USERCookie = new Cookie(USERID_PARAM, email);	
		USERCookie.setDomain(WAP_URL);
		USERCookie.setMaxAge(60*60*24*365);
		USERCookie.setPath("/");
		response.addCookie(USERCookie);
		
		Cookie PWDCookie = new Cookie(PASSWORD_PARAM, pwd);
		PWDCookie.setDomain(WAP_URL);
		PWDCookie.setMaxAge(60*60*24*365);
		PWDCookie.setPath("/");
		response.addCookie(PWDCookie);
		System.out.println("clear==false!!");
	}

	response.setContentType("text/vnd.wap.wml");
	response.setHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
//	response.setHeader("Last-Modified", gmdate("D, d M Y H:i:s") . " GMT");
	response.setHeader("Cache-Control", "max-age=0, no-cache, must-revalidate");
	response.setHeader("Pragma", "no-cache");
	try {
	
		PrintWriter out = response.getWriter();
		out.print("<?xml version=\"1.0\"?>\n");
		out.print("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\"\n");
		out.print("\"http://www.wapforum.org/DTD/wml_1.1.xml\">\n");
	}
	catch (IOException ioExcept) {
	
	}
}

//////////////////////////////////////////////////////////////
//
//	validateUSer()
//
//		Validates a user using email address and password.
//

String validateUser(HttpSession session, HttpServletRequest request, HttpServletResponse response) {

String email = "";
String pwd = "";
String errMsg = "";
String screenName = "";

ServletContext ctx = getServletConfig().getServletContext();

System.out.println((String)session.getAttribute(USER_EMAIL_SESSID));

email = (String)session.getAttribute(USER_EMAIL_SESSID);
pwd = (String)session.getAttribute(USER_PASSWORD_SESSID);

if (email == null) {
	email = request.getParameter(USERID_PARAM);
}
if (pwd == null) {
	pwd = request.getParameter(PASSWORD_PARAM);
}

if (email == null || pwd == null) {

	errMsg += "Please enter an email address";
	
} else {
	email = email.toLowerCase();
	// 	Check email format.
	//	PRD70, PRD71
	//
	if (email.length() < 1) {
		errMsg += ctx.getInitParameter("MSG.PRD70") + "<br>";
	}
	else {
		//	Check email format
		//
		try {
			if (!isEmailValid(email)) {
				email = "";
				errMsg += ctx.getInitParameter("MSG.PRD70") + "<br>";
			} else {
				//	Check password, only if email OK (PRD72).
				//
				if ( ( pwd.length() < 4) || ( pwd.indexOf(' ') != -1 ) ) {
					errMsg += ctx.getInitParameter("MSG.PRD72") + "<br>";
				}
			}
		}
		catch (AlkExcept ae) {
			switch(ae.errCode()) {
				case 7030:
					errMsg += "Invalid email address.";
					break;
				
				case 6503:
					errMsg += "Your account was not found in our database or your password is incorrect.";
					break;
				
				default:
					errMsg = ae.toString();
					break;
			}
		}
	}

	//	If all OK, try to validate user.
	//
	if (errMsg.length() == 0) {
		try {
			IAccountManager acctMgr = getAcctMgr();
//			System.out.println("got acct mgr.");
			try {
				SystemUser su = acctMgr.validateUser(email, pwd);
				//((IAccountManagerBean)acctMgr).remove();
				//IAccountManager acctMgr = (IAccountManager)getAcctMgr();
				screenName = acctMgr.getScreenName(su);
				//acctMgr.remove(); 
				acctMgr = null;
				acctMgr = null;
				session.setAttribute(USER_SESSID, su);
				session.setAttribute(USER_EMAIL_SESSID, email);
				session.setAttribute(USER_PASSWORD_SESSID, pwd);
				session.setAttribute(USER_SCREENNAME_SESSID, screenName);
				//response.setHeader("LOCATION", MY_ALKINDI_PAGE);
			}
			catch (RemoteException re) {
			}
		}
		catch (AlkExcept ae) {
			switch(ae.errCode()) {
				case 6502:
					errMsg += "Account suspended. Please contact Customer Service for further assistance.";
					break;
				
				case 6503:
					errMsg += "Your account was not found in our database or your password is incorrect.";
					break;
				
				default:
					errMsg = ae.toString();
					break;
			}
		}
	}

}

if (errMsg.length() != 0) {

	errMsg = "Please enter your email address and password. If the problem persists, go to www.alkindi.com for further assistance";
}
return errMsg;

}

//////////////////////////////////////////////////////////////
//
//	writePostField()
//
//		Writes a post field string.
//

String writePostField(String name,String value) {

	return "<postfield name=\"" + name + "\" value=\"" + value + "\"/>";

}

/////////////////////////////////////////////////////////////
//
//      writeURL()
//
//              Writes a URL string.
//

String writeURL(String location, HttpSession session) {

	return WAP_URL+"/"+location+"?JSESSIONID="+session.getId();

}
%>
